import static java.lang.System.out;
public class GreedGameSim {

	private static Player[] players;

	public static void main(String[] args) {


		boolean verbose=false;
		int numberOfPlayers=100;
		out.println("\n Die on 2\n");
		for(int i=0;i<10;i++)
			out.println( doGreedGameDeathOn2(verbose, numberOfPlayers));
		out.println("\n Die on Doubles\n");
		for(int i=0;i<10;i++)
			out.println( doGreedGameDeathOnDoubles(false, numberOfPlayers));
	}
	public static boolean stillStanding(){
		for (int i=0; i<players.length; i++){
			if (players[i].isStanding())
				return true;
		}
		return false;
	}
	public static void resetPlayers(){
		for (Player p:players){
			p.setStanding(true);
		}

	}
	public static GameStats doGreedGameDeathOn2(boolean verbose, int n){
		players=new Player[n];
		int[] zapped = new int[5];
		for (int i=0; i<5;i++)
			zapped[i]=0;
		for (int i=0;i<players.length;i++)
			players[i]=new Player();
		Die d1=new Die(6);
		Die d2=new Die(6);
		for(int round=0;round<5;round++){
    		int roundTotal=d1.getValue()+d2.getValue();
        if (verbose){
        		out.println("\nDie: "+d1.getValue()+" "+d2.getValue()+"- starting with "+roundTotal+" for round "+(round+1));
        }
        	int zappedCount=0;
        	boolean firstRoll=true;
        	while (stillStanding()){
        		if(!firstRoll){
        			d1= new Die(6);
	        		if(verbose){
	        			out.println("\nrolled a "+d1.getValue());
	        		}
        		}
        		if (!firstRoll && d1.getValue()==2){
        			for (Player p:players){
        				boolean changed=p.setStanding(false);
        				if (changed)
        					zappedCount++;
        			}
        		}else{//not a 2 or first roll of round
        			int s=0;
        			if(!firstRoll)
        				roundTotal+=d1.getValue();
        			for (Player p:players){
        				p.decide(roundTotal);
        				if (p.isStanding())
							s++;

        			}
        			if (verbose) {

    					out.print(roundTotal+" pts so far - "+s+" still standing ");
    				}
        		}

        		firstRoll=false;

        	}//end of while standing
        	roundTotal=0;
        	if(verbose){
        		out.println(zappedCount+" got zero points round "+(round+1));
        	}
        	zapped[round]=zappedCount;
        	resetPlayers();
    }//end of round loop
		return new GameStats(players, zapped);
	}

	public static GameStats doGreedGameDeathOnDoubles(boolean verbose, int n){
		players=new Player[n];
		int[] zapped = new int[5];
		for (int i=0; i<5;i++)
			zapped[i]=0;
		for (int i=0;i<players.length;i++)
			players[i]=new Player();
		Die d1=new Die(6);
		Die d2=new Die(6);
		for(int round=0;round<5;round++){
    		int roundTotal=d1.getValue()+d2.getValue();
        if (verbose){
        		out.println("\nDie: "+d1.getValue()+" "+d2.getValue()+"- starting with "+roundTotal+" for round "+(round+1));
        }
        	int zappedCount=0;
        	boolean firstRoll=true;
        	while (stillStanding()){
        		if(!firstRoll){
        			d1= new Die(6);
        			d2= new Die(6);
	        		if(verbose){
	        			out.println("\nrolled a "+d1.getValue()+" "+d2.getValue());
	        		}
        		}
        		if (!firstRoll && d1.getValue()==d2.getValue()){
        			for (Player p:players){
        				boolean changed=p.setStanding(false);
        				if (changed)
        					zappedCount++;
        			}
        		}else{//not doubles or first roll of round
        			int s=0;
        			if(!firstRoll)
        				roundTotal+=d1.getValue()+d2.getValue();
        			for (Player p:players){
        				p.decide(roundTotal);
        				if (p.isStanding())
							s++;

        			}
        			if (verbose) {

    					out.print(roundTotal+" pts so far - "+s+" still standing ");
    				}
        		}

        		firstRoll=false;

        	}//end of while standing
        	roundTotal=0;
        	if(verbose){
        		out.println(zappedCount+" got zero points round "+(round+1));
        	}
        	zapped[round]=zappedCount;
        	resetPlayers();
    }//end of round loop
		return new GameStats(players, zapped);
	}


}
